#ifndef __CDouble__
#define __CDouble__

//	===========================================================================

#include "CString.hpp"

//	===========================================================================

using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace Basics
	{
		/**
		 * @class CDouble CDouble.hpp
		 * @brief Wrapper around built in double type
		 *
		 * Basic wrapper around a built in double type giving it CCountedObject functionality
		 *
		 * @date 21/08/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.0.1 Made the constructor default
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CDouble.hpp,v 1.3 2007/02/08 21:06:44 paul Exp $
		 */
		class CDouble : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param value The value to store
			 */
			CDouble(const double value = 0.0);

			/**
			 * Destruction
			 */
			virtual ~CDouble();

//	===========================================================================

			/**
			 * Assignment operator
			 * @param value The value to store
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator = (const CDouble &value);

			/**
			 * Assignment operator
			 * @param value The value to store
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator = (const double value);

			/**
			 * Equality operator
			 * @param value The value to compare to
			 * @retval bool True if values are equal, false otherwise
			 */
			bool operator == (const CDouble &value);

			/**
			 * Equality operator
			 * @param value The value to compare to
			 * @retval bool True if values are equal, false otherwise
			 */
			bool operator == (const double value);

			/**
			 * InEquality operator
			 * @param value The value to compare to
			 * @retval bool True if values are inequal, false otherwise
			 */
			bool operator != (const CDouble &value);

			/**
			 * InEquality operator
			 * @param value The value to compare to
			 * @retval bool True if values are inequal, false otherwise
			 */
			bool operator != (const double value);

			/**
			 * Addition operator
			 * @param value The value to add to this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator + (const CDouble &value);

			/**
			 * Addition operator
			 * @param value The value to add to this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator + (const double value);

			/**
			 * Subtraction operator
			 * @param value The value to subtract from this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator - (const CDouble &value);

			/**
			 * Subtraction operator
			 * @param value The value to subtract from this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator - (const double value);

			/**
			 * Multiplication operator
			 * @param value The value to multiply with this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator * (const CDouble &value);

			/**
			 * Multiplication operator
			 * @param value The value to multiply with this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator * (const double value);

			/**
			 * Division operator
			 * @param value The value to divide with this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator / (const CDouble &value);

			/**
			 * Division operator
			 * @param value The value to divide with this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator / (const double value);

			/**
			 * Plus equals operator
			 * @param value The value to add to this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator += (const CDouble &value);

			/**
			 * Plus equals operator
			 * @param value The value to add to this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator += (const double value);

			/**
			 * Neg equals operator
			 * @param value The value to subtract from this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator -= (const CDouble &value);

			/**
			 * Neg equals operator
			 * @param value The value to subtract from this
			 * @retval CDouble& A reference to this
			 */
			CDouble &operator -= (const double value);

			/**
			 * ! operator
			 * @retval bool True if value == 0, false otherwise
			 */
			bool operator ! ();

//	===========================================================================

			/**
			 * Set the value
			 * @param value The value to store
			 */
			void setValue(const CDouble &value);

			/**
			 * Set the value
			 * @param value The value to store
			 */
			void setValue(const double value);

			/**
			 * Get the value
			 * @retval double The value
			 */
			double getValue() const;

			/**
			 * Get as a string
			 * @param decimalPlaces The number of decimal places precision required
			 * @retval CString The double as a string
			 */
			CString getValueAsString(const long decimalPlaces = 2) const;

//	===========================================================================

			/**
			 * Get a description of the object
			 * @param string On return is filled with the description
			 * @param size The size of the stirng
			 */
			virtual void getObjectDescription(char *string, const long size) const;

//	===========================================================================

		protected:

//	===========================================================================

			double m_value;		/**< The value stored */

		};
	}
}
#endif	// End of CDouble.hpp